/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util;

import de.keksuccino.fancymenu.util.input.MouseUtils;
import java.util.Objects;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaEvents {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int GLFW_NO_MODIFIERS = 0;
    @Nullable
    private static class_11910 latestVanillaMouseButtonInfo = null;
    private static long latestVanillaMouseButtonInfoCachingTime = -1L;

    @NotNull
    public static class_11910 getLatestVanillaMouseButtonInfoOrDummy() {
        long now = System.currentTimeMillis();
        if (latestVanillaMouseButtonInfoCachingTime != -1L && latestVanillaMouseButtonInfoCachingTime + 2000L < now) {
            LOGGER.warn("[FANCYMENU] Getting an possibly outdated latestVanillaMouseButtonInfo! Last caching time is more than 2 seconds in the past! This should be avoided.", (Throwable)new Exception("Outdated MouseButtonInfo in VanillaEvents!"));
        }
        if (latestVanillaMouseButtonInfo != null) {
            return latestVanillaMouseButtonInfo;
        }
        LOGGER.warn("[FANCYMENU] Getting latestVanillaMouseButtonInfo before caching it! This should be avoided.", (Throwable)new Exception("No MouseButtonInfo cached in VanillaEvents!"));
        return new class_11910(0, -1);
    }

    public static void updateLatestVanillaMouseButtonInfo(@NotNull class_11910 info) {
        latestVanillaMouseButtonInfoCachingTime = System.currentTimeMillis();
        latestVanillaMouseButtonInfo = Objects.requireNonNull(info);
    }

    @NotNull
    public static class_11909 mouseButtonEvent(double mouseX, double mouseY, @NotNull class_11910 info) {
        return new class_11909(mouseX, mouseY, info);
    }

    @NotNull
    public static class_11909 mouseButtonEvent(double mouseX, double mouseY, int button, int modifiers) {
        return VanillaEvents.mouseButtonEvent(mouseX, mouseY, new class_11910(button, modifiers));
    }

    @NotNull
    public static class_11909 mouseButtonEvent(double mouseX, double mouseY, int button) {
        class_11910 cached = VanillaEvents.getLatestVanillaMouseButtonInfoOrDummy();
        return VanillaEvents.mouseButtonEvent(mouseX, mouseY, new class_11910(button, cached.comp_4797()));
    }

    @NotNull
    public static class_11909 mouseButtonEvent(int button) {
        class_11910 cached = VanillaEvents.getLatestVanillaMouseButtonInfoOrDummy();
        return VanillaEvents.mouseButtonEvent(MouseUtils.getScaledMouseX(), MouseUtils.getScaledMouseY(), new class_11910(button, cached.comp_4797()));
    }

    @NotNull
    public static class_11909 mouseButtonEvent(int button, int modifiers) {
        return VanillaEvents.mouseButtonEvent(MouseUtils.getScaledMouseX(), MouseUtils.getScaledMouseY(), new class_11910(button, modifiers));
    }

    @NotNull
    public static class_11909 mouseButtonEvent(double mouseX, double mouseY) {
        return VanillaEvents.mouseButtonEvent(mouseX, mouseY, VanillaEvents.getLatestVanillaMouseButtonInfoOrDummy());
    }

    @NotNull
    public static class_11909 mouseButtonEvent() {
        return VanillaEvents.mouseButtonEvent(MouseUtils.getScaledMouseX(), MouseUtils.getScaledMouseY(), VanillaEvents.getLatestVanillaMouseButtonInfoOrDummy());
    }
}

